# coding: iso-8859-15

import threading
import random

##!!!!##################################################################################################
#### Own written code can be placed above this commentblock . Do not change or delete commentblock! ####
########################################################################################################
##** Code created by generator - DO NOT CHANGE! **##

class TelegramGeneratorWithRandomInterval10704(hsl20_4.BaseModule):

    def __init__(self, homeserver_context):
        hsl20_4.BaseModule.__init__(self, homeserver_context, "hsl20_4_fw_examples")
        self.FRAMEWORK = self._get_framework()
        self.LOGGER = self._get_logger(hsl20_4.LOGGING_NONE,())
        self.PIN_I_I1_ON_OFF=1
        self.PIN_O_O1=1
        self.PIN_O_O2_NEG=2
        self.FRAMEWORK._run_in_context_thread(self.on_init)

########################################################################################################
#### Own written code can be placed after this commentblock . Do not change or delete commentblock! ####
###################################################################################################!!!##

    def on_init(self):
        # From here the code runs in the context thread of the module context.
        # If this thread is blocked, it does not block the whole logic processing.
        # Just the processing of all modules of this context is blocked.
        self.enabled = self._get_input_value(self.PIN_I_I1_ON_OFF) != 0
        # Create an event that signals the cancellation of the infinite loop (method "loop").
        self.cancel_event = threading.Event()
        # Create a lock that prevents the execution of the infinite loop (method "loop") from multiple threads.
        self.loop_lock = threading.Lock()
        # If there is a value unequal 0 on input 1 start the infinite loop (method "loop") in an extra thread.
        if self.enabled:
            loop_thread = threading.Thread(target=self.loop)
            loop_thread.start()

    def on_input_value(self, index, value):
        # From here the code runs in the context thread of the module context.
        # If this thread is blocked, it does not block the whole logic processing.
        # Just the processing of all modules of this context is blocked.
        if index == self.PIN_I_I1_ON_OFF:
            if self.enabled and value == 0:
                # When the value 0 arrives on input 1 und the module is enabled,
                # cancel the infinite loop by setting the event "cancel_event".
                self.cancel_event.set()
            elif not self.enabled and value != 0:
                # When a other value than 0 arrives on input 1 und the module is disabled,
                # start the infinite loop (method "loop") in an extra thread.
                loop_thread = threading.Thread(target=self.loop)
                loop_thread.start()
            self.enabled = value != 0

    def loop(self):
        # From here the code runs in an extra thread. This thread does not block any other thread.
        # Neither the logic execution nor the module context.
        with self.loop_lock:
            while True:
                # Determine a random timeout between 1 and 10 seconds.
                timeout=random.random()*9+1
                # Wait max "timeout" seconds or until "cancel_event" is set.
                self.cancel_event.wait(timeout)
                if self.cancel_event.is_set():
                    # When "cancel_event" is set, exit this method and this thread.
                    self.cancel_event.clear()
                    return
                self._set_output_value(self.PIN_O_O1, 1)
                self._set_output_value(self.PIN_O_O2_NEG, 0)

